/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm;

import com.sammy.minersdelight.content.block.copper_pot.CopperPotBlockEntity;
import com.sammy.minersdelight.setup.MDBlocks;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPointType;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderTag;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createcentralkitchen.content.contraptions.blazeStove.BlazeStoveBlockEntity;
import plus.dragons.createcentralkitchen.content.logistics.item.guide.minersCooking.MinersCookingGuide;
import plus.dragons.createcentralkitchen.content.logistics.item.guide.minersCooking.MinersCookingGuideItem;
import plus.dragons.createcentralkitchen.foundation.ponder.PonderArmInteractionPointType;

public class CopperPotPoint
extends ArmInteractionPoint {
    public static final int INPUT_SLOT_COUNT = 4;
    public static final int CONTAINER_SLOT = 5;
    public static final int OUTPUT_SLOT = 6;

    public CopperPotPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        super(type, level, pos, state);
    }

    protected Vec3 getInteractionPositionVector() {
        return Vec3.m_82514_((Vec3i)this.pos, (double)0.625);
    }

    @Nullable
    protected IItemHandler getHandler() {
        if (!this.cachedHandler.isPresent()) {
            BlockEntity be = this.level.m_7702_(this.pos);
            if (!(be instanceof CopperPotBlockEntity)) {
                return null;
            }
            CopperPotBlockEntity copperPot = (CopperPotBlockEntity)be;
            this.cachedHandler = LazyOptional.of(() -> ((CopperPotBlockEntity)copperPot).getInventory());
        }
        return (IItemHandler)this.cachedHandler.orElse(null);
    }

    public ItemStack insert(ItemStack stack, boolean simulate) {
        BlockEntity blockEntity = this.level.m_7702_(this.pos.m_7495_());
        if (!(blockEntity instanceof BlazeStoveBlockEntity)) {
            return stack;
        }
        BlazeStoveBlockEntity blazeStove = (BlazeStoveBlockEntity)blockEntity;
        ItemStack guideStack = blazeStove.getGuide();
        if (!(guideStack.m_41720_() instanceof MinersCookingGuideItem)) {
            return stack;
        }
        MinersCookingGuide guide = MinersCookingGuide.of(guideStack);
        if (guide.getResult().m_41619_()) {
            return stack;
        }
        IItemHandler inventory = this.getHandler();
        if (inventory == null) {
            return stack;
        }
        if (inventory.getStackInSlot(5).m_41619_() && guide.isContainer(stack)) {
            return inventory.insertItem(5, stack, simulate);
        }
        boolean[] neededSlots = new boolean[4];
        int neededSlotCount = 0;
        for (int slot = 0; slot < 4; ++slot) {
            if (!inventory.getStackInSlot(slot).m_41619_() || !guide.needIngredient(slot) || !guide.isIngredient(slot, stack)) continue;
            neededSlots[slot] = true;
            ++neededSlotCount;
        }
        if (neededSlotCount == 0) {
            return stack;
        }
        int countPerSlot = stack.m_41613_() / neededSlotCount;
        ItemStack ret = stack.m_41777_();
        for (int slot = 0; slot < 4; ++slot) {
            if (!neededSlots[slot]) continue;
            ItemStack inserted = ret.m_41620_(countPerSlot);
            inventory.insertItem(slot, inserted, simulate);
        }
        return ret;
    }

    public ItemStack extract(int slot, int amount, boolean simulate) {
        ItemStack container;
        ItemStack ingredient;
        if (slot == 6) {
            return super.extract(slot, amount, simulate);
        }
        BlockEntity blockEntity = this.level.m_7702_(this.pos.m_7495_());
        if (!(blockEntity instanceof BlazeStoveBlockEntity)) {
            return ItemStack.f_41583_;
        }
        BlazeStoveBlockEntity blazeStove = (BlazeStoveBlockEntity)blockEntity;
        ItemStack guideStack = blazeStove.getGuide();
        if (!(guideStack.m_41720_() instanceof MinersCookingGuideItem)) {
            return ItemStack.f_41583_;
        }
        MinersCookingGuide guide = MinersCookingGuide.of(guideStack);
        if (guide.getResult().m_41619_()) {
            return ItemStack.f_41583_;
        }
        IItemHandler inventory = this.getHandler();
        if (inventory == null) {
            return ItemStack.f_41583_;
        }
        if (slot < 4 ? !(ingredient = inventory.getStackInSlot(slot)).m_41619_() && !guide.isIngredient(slot, ingredient) : slot == 5 && !(container = inventory.getStackInSlot(slot)).m_41619_() && !guide.isContainer(container)) {
            return inventory.extractItem(slot, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    public static class Type
    extends PonderArmInteractionPointType {
        public Type(ResourceLocation id) {
            super(id);
        }

        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return level.m_7702_(pos) instanceof CopperPotBlockEntity && level.m_7702_(pos.m_7495_()) instanceof BlazeStoveBlockEntity;
        }

        @Nullable
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new CopperPotPoint(this, level, pos, state);
        }

        @Override
        public void addToPonderTag(Consumer<ItemLike> consumer) {
            PonderRegistry.TAGS.forTag(PonderTag.ARM_TARGETS).add((ItemLike)MDBlocks.COPPER_POT.get());
        }
    }
}

